//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
class C_Connection
{
	private	:
		int		m_Socket;
		char		m_buff[];
		string 	m_info;
		bool 		m_NewLine;
	public	:
//+------------------------------------------------------------------+
		C_Connection(string addr, ushort port, ushort timeout = 1000)
			:m_Socket(INVALID_HANDLE),
			 m_info(""),
			 m_NewLine(true)
		{
			if ((m_Socket = SocketCreate()) == INVALID_HANDLE)	Print("Unable to create socket. Error: ", GetLastError());
			else if (SocketConnect(m_Socket, addr, port, timeout)) return;
			else Print("Connection with the address [", addr,"] in port: ",port, " failed. Error code: ", GetLastError());
			SetUserError(1);
		}
//+------------------------------------------------------------------+
		~C_Connection()
		{
			SocketClose(m_Socket);
		}
//+------------------------------------------------------------------+
		bool ConnectionWrite(string szMsg)
		{
			int len = StringToCharArray(szMsg, m_buff) - 1;

			if (m_Socket != INVALID_HANDLE)
				if (len >= 0)
					if (SocketSend(m_Socket, m_buff, len) == len)
						return true;
			Print("Connection Write: FAILED...");

			return false;
		}
//+------------------------------------------------------------------+
		const string ConnectionRead(ushort timeout = 500)
		{
			int ret;

			if (m_NewLine)
			{
				m_info = "";
				m_NewLine = false;
			}
			ret = SocketRead(m_Socket, m_buff, SocketIsReadable(m_Socket), timeout);
			if (ret > 0)
			{
				m_info += CharArrayToString(m_buff, 0, ret);
				for (ret--; (ret >= 0) && (!m_NewLine); ret--)
					m_NewLine = (m_buff[ret] == '\n') || (m_buff[ret] == '\r');
			}
			
			return (m_NewLine ? m_info : "");
		}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+